<?php
namespace WprAddonsPro\Modules\SearchPro\Widgets;

use Elementor\Controls_Manager;
use WprAddons\Classes\Utilities;

if ( ! defined( 'ABSPATH' ) ) exit;

class Wpr_Search_Pro extends \WprAddons\Modules\Search\Widgets\Wpr_Search {

	public function add_control_search_query() {
		$search_post_type = Utilities::get_custom_types_of( 'post', false );
		$search_post_type = array_merge( [ 'all' => esc_html__( 'All', 'wpr-addons' ) ], $search_post_type );

		$this->add_control(
			'search_query',
			[
				'label' => esc_html__( 'Select Query', 'wpr-addons' ),
				'type' => Controls_Manager::SELECT,
				'label_block' => false,
				'options' => $search_post_type,
				'default' => 'all',
			]
		);
	}

	protected function render() {
		// Get Settings
		$settings = $this->get_settings();

		$this->add_render_attribute(
			'input', [
				'placeholder' => $settings['search_placeholder'],
				'class' => 'wpr-search-form-input',
				'type' => 'search',
				'name' => 's',
				'title' => esc_html__( 'Search', 'wpr-addons' ),
				'value' => get_search_query(),
			]
		);

		?>

		<form role="search" method="get" class="wpr-search-form" action="<?php echo home_url(); ?>">
			<?php if ( 'all' !== $settings['search_query'] ) : ?>
				<input type="hidden" name="post_type" value="<?php echo esc_attr( $settings['search_query'] ); ?>" />
			<?php endif; ?>

			<div class="wpr-search-form-input-wrap elementor-clearfix">
				<input <?php echo $this->get_render_attribute_string( 'input' ); ?>>
				<?php
				if ( $settings['search_btn_style'] === 'inner' ) {
					$this->render_search_submit_btn();
				}
				?>
			</div>

			<?php

			if ( $settings['search_btn_style'] === 'outer' ) {
				$this->render_search_submit_btn();
			}

			?>
			
		</form>

		<?php

	}
	
}